package cz.muni.ics.oidc.saml;

import org.springframework.security.core.AuthenticationException;
import org.springframework.security.web.authentication.SimpleUrlAuthenticationFailureHandler;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;

import static cz.muni.ics.oidc.web.controllers.LoginController.ATTR_EXCEPTION;

public class PerunAuthenticationFailureHandler extends SimpleUrlAuthenticationFailureHandler {

    @Override
    public void onAuthenticationFailure(HttpServletRequest request, HttpServletResponse response,
                                        AuthenticationException exception) throws IOException, ServletException
    {
        request.setAttribute(ATTR_EXCEPTION, exception);
        super.onAuthenticationFailure(request, response, exception);
    }
}
