package cz.muni.ics.oidc.web.controllers;

import cz.muni.ics.oidc.server.configurations.PerunOidcConfig;
import cz.muni.ics.oidc.web.WebHtmlClasses;
import cz.muni.ics.openid.connect.view.HttpCodeView;
import cz.muni.ics.openid.connect.view.JsonErrorView;
import lombok.extern.slf4j.Slf4j;
import org.opensaml.saml2.core.StatusCode;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.security.saml.SAMLStatusException;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;

import javax.servlet.http.HttpServletRequest;
import java.util.Map;

@Controller
@Slf4j
public class LoginController {

	public static final String MAPPING_SUCCESS = "/login_success";
	public static final String MAPPING_FAILURE = "/login_failure";
	public static final String ATTR_EXCEPTION = "exception_in_auth";

	private final WebHtmlClasses htmlClasses;
	private final PerunOidcConfig perunOidcConfig;

	@Autowired
	public LoginController(PerunOidcConfig perunOidcConfig, WebHtmlClasses htmlClasses) {
		this.perunOidcConfig = perunOidcConfig;
		this.htmlClasses = htmlClasses;
	}

	@RequestMapping(value = MAPPING_SUCCESS)
	public String loginSuccess(HttpServletRequest req, Map<String, Object> model) {
		ControllerUtils.setPageOptions(model, req, htmlClasses, perunOidcConfig);
		return "login_success";
	}

	@RequestMapping(value = MAPPING_FAILURE)
	public String loginFailure(HttpServletRequest req, Map<String, Object> model) {
		Throwable object = (Throwable) req.getAttribute(ATTR_EXCEPTION);
		if (object != null) {
			Throwable t = object;
			SAMLStatusException exc = null;
			while (t != null) {
				if (t instanceof SAMLStatusException) {
					exc = (SAMLStatusException) t;
					break;
				}
				t = t.getCause();
			}
			if (exc != null) {
				String code = exc.getStatusCode();
				if (StatusCode.NO_AUTHN_CONTEXT_URI.equalsIgnoreCase(code)) {
					model.put(HttpCodeView.CODE, HttpStatus.FORBIDDEN);
					model.put(JsonErrorView.ERROR, "unmet_authentication_requirements");
					model.put(JsonErrorView.ERROR_MESSAGE, "Cannot log in. MFA has been requested and not performed");
					return JsonErrorView.VIEWNAME;
				}
			}
		}

		ControllerUtils.setPageOptions(model, req, htmlClasses, perunOidcConfig);
		return "login_failure";
	}

}
